---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/definition"
aliases:
  - Unmanifested Difference
  - Under-resolution
polarity: P-
---

# Zero

> In Delta Theory, "Zero" is not numeric 0 or an ontological primitive. It names a difference that is below the current resolution threshold ε — operationally non‑actionable and indistinguishable for a given interface or domain.

---

## Definition

In Delta Theory, **Zero** denotes absence of manifested difference:
- |∆| < ε for the relevant interface
- Will not pass gates or bind into form
- Context-dependent (ε varies by domain)

Key aspects:
- Not a primitive or constant
- Not numeric 0 in arithmetic
- Not Void (which is opaque outside)

---

## Dual‑register mapping

### Technical (network/computational)

| Term concept | Network construct | Interface example |
|-------------|------------------|-------------------|
| Resolution | Threshold | `Epsilon`, `MinVal` |
| Filter | Gate | `Filter`, `Cutoff` |
| Noise | Sub-threshold | `Noise`, `Jitter` |

### Humane (biological/relational)

| Term concept | Humane construct | Example |
|-------------|------------------|----------|
| Resolution | Notice limit | "Too small to see" |
| Filter | Attention gate | "Doesn't register" |
| Noise | Background | "Just noise" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Threshold | Notice | What we can detect |
| Gate | Filter | What gets through |
| Sub-threshold | Background | What fades away |

### Domain Examples

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Quantum limit | Natural threshold |
| Networks | Noise floor | Living boundary |
| Cognition | Subliminal | Below awareness |
| Systems | Error margin | Natural limit |

---

## Scale Effects

How Zero manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum zero | Planck scale |
| λV | State cutoff | Energy gap |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Notice threshold | Attention limit |
| ∇S | Pattern cutoff | Form boundary |

### Universe Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal zero | Event horizon |
| λV | Signal cutoff | Cosmic limit |

Note: At each scale, "Zero" manifests as a specific form of threshold or cutoff relative to that scale's fundamental limits.

---

## Ontological Role

| Domain | Role |
|--------|------|
| Structure | Sets minimal feature |
| Void | Defines opacity floor |
| Awareness | Bounds coherence |

Zero marks the boundary between manifested and unmanifested difference.

---

## Comparisons

Compare with related terms:

| Term | Distinction | Example |
|------|------------|---------|
| Zero | Below threshold | Noise floor |
| Void | Outside opacity | Black box |
| Infinite | Beyond bound | Overflow |

---

## Recursive Function

Zero appears at resolution boundary:

$$
|∆| < ε \implies \text{Zero}
$$

Where:
- |∆| = difference magnitude
- ε = resolution quantum
- Zero = unmanifested state

---

## Design rationale

This term must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical thresholds nor experiential invisibility alone captures its full meaning.

---

## See Also

- [[ε — Difference Resolution Quantum (constant)]]
- [[Void]]
- [[Structure]]
- [[Infinite]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale effects documented